unit Main;

interface

uses
    SysUtils, 
    WinTypes,   
    WinProcs, 
    Messages, 
    Classes,         
    Graphics, 
    Controls,
    Forms,     
    Dialogs, 
    StdCtrls,
    ExtCtrls,
    Menus,
    Nwlib,
    Nwtools,
    NWServer,
    NwProp, 
    Nwnds, nwbase;

type
  TwinMain = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    userid: TLabel;
    objectid: TLabel;
    netname: TLabel;
    server: TLabel;
    label6: TLabel;
    serverdate: TLabel;
    Label2: TLabel;
    netDrive: TLabel;
    Panel1: TPanel;
    foot1: TLabel;
    foot2: TLabel;
    everyone: TListBox;
    Header1: THeader;
    groups: TListBox;
    Header2: THeader;
    Panel2: TPanel;
    username: TLabel;
    loggedin: TLabel;
    bEnable: TButton;
    bDisable: TButton;
    bLogout: TButton;
    bExit: TButton;
    isManager: TCheckBox;
    isSuper: TCheckBox;
    isConsole: TCheckBox;
    canLogin: TCheckBox;
    Panel3: TPanel;
    serverlist: TListBox;
    servertext: TEdit;
    volumes: TListBox;
    mapList: TListBox;
    Header3: THeader;
    semaphoreBtn: TButton;
    rightsBtn: TButton;
    binderyBtn: TButton;
    filesBtn: TButton;
    statsBtn: TButton;
    mapBtn: TButton;
    captureBtn: TButton;
    ndsBtn: TButton;
    everyonePopup: TPopupMenu;
    ChangePassword1: TMenuItem;
    SendLineMessage1: TMenuItem;
    mapPopup: TPopupMenu;
    mapDelMenu: TMenuItem;
    mapInfoMenu: TMenuItem;
    serverListPopup: TPopupMenu;
    serverListPrefServer: TMenuItem;
    serverListPopupStats: TMenuItem;
    userListBtn: TButton;
    NWBase1: TNWBase;
    procedure FormShow(Sender: TObject);
    procedure everyoneDblClick(Sender: TObject);
    procedure groupsDblClick(Sender: TObject);
    procedure bExitClick(Sender: TObject);
    procedure mapBtnClick(Sender: TObject);
    procedure bEnableClick(Sender: TObject);
    procedure bDisableClick(Sender: TObject);
    procedure serverlistDblClick(Sender: TObject);
    procedure bLogoutClick(Sender: TObject);
    procedure captureBtnClick(Sender: TObject);
    procedure mapListDblClick(Sender: TObject);
    procedure statsBtnClick(Sender: TObject);
    procedure filesBtnClick(Sender: TObject);
    procedure rightsBtnClick(Sender: TObject);
    procedure ChangePassword1Click(Sender: TObject);
    procedure SendLineMessage1Click(Sender: TObject);
    procedure ndsBtnClick(Sender: TObject);
    procedure binderyBtnClick(Sender: TObject);
    procedure semaphoreBtnClick(Sender: TObject);
    procedure mapInfoMenuClick(Sender: TObject);
    procedure mapDelMenuClick(Sender: TObject);
    procedure userListBtnClick(Sender: TObject);
    procedure serverListPopupStatsClick(Sender: TObject);
    procedure volumesDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

  end;

var
  winMain: TwinMain;

implementation

{$R *.DFM}

uses
  NDS,
  Stats,
  userStat,
  PrintCap,
  semaphr,
  Prop,
  files,
  userList;

procedure TwinMain.FormShow(Sender: TObject);
  begin
     {see if NDS exists}
     ndsBtn.enabled := nwBase1.ndsAvailable ;
       
     { Show Footer }
     if nwBase1.ndsAvailable then
       foot1.caption := ndsWhoAmI 
     else
       foot1.caption := whoAmI(0) + '  (' +
                        intToStr(getConnectID(0)) + ')';

     foot2.caption := 'NWLib Ver: ' + getNWLibVersion ;

     { Various Labels }
     userid.caption     := whoAmI(0) ; 
     objectid.caption   := getObjID(0,userid.caption,nw_user) ;
     server.caption     := getServerName(0) ;
     serverdate.caption := formatDateTime('mm/dd/yyyy',getServerDate(0)) + ' @ ' +
                           formatDateTime('hh:nn am/pm',getServerTime(0));

     netname.caption    := fullName(0,userid.caption) ; 
     netdrive.caption   := getFirstNetDrive + ':' + '     Next Free: ' +
                           getNextNetDrive + ':' ;
     { checkboxes }
     isSuper.checked    := secureEquiv(0,userid.caption,'SUPERVISOR') or
                           secureEquiv(0,userid.caption,'ADMIN') ; 
     isConsole.checked  := isConsoleOperator(0);
     isManager.checked  := isNWManager(0) ;
     canLogin.checked   := serverLoginOK(0) ;

     { Popup Menu Disable ChangePW Option if not SUPERVISOR }
     if not isSuper.checked then
       everyonePopup.items[0].enabled := false ;

     { Disable 'Disable Login' Button }
     if not isConsoleOperator(getPrimaryServerID) then
       bDisable.enabled := false ;

     { Test the Login (Attach) Function - note intended typo to prevent lockout}
     if NWLogin('fs1','FSUPERVISOR','badmofo',nw_user) then
       okBox('SUPERVISOR Login Successful!') ;

     { Password Check - note intended typo to prevent lockout}
     if NWPassCheck(0,'ADMIN/SUPERVISOR','SECRET_PASSWORD') then
       AlertBox('Wow!  I Guessed Supervisor''s Password!!') ;

     { Build EVERYONE List }
     everyone.items.addStrings(getMemberList(0,'EVERYONE',true)) ;

     { Build GroupList }
     groups.items.addStrings(getBinderyList(0,nw_group)) ;  
     
     { Build ServerList }
     serverList.items.addStrings(sList) ;      

     { Network Volume Listing }
     volumes.items.addStrings( getVolumes(0) ) ;

     { Build Drive Map List }
     mapList.items.addStrings( mapShow ) ; 

  end;

procedure TwinMain.everyoneDblClick(Sender: TObject);
  var
    nloop    : integer ;
    tempList : TStringList ;
    ctemp    : string ;
  begin
    ctemp := everyone.items[everyone.itemindex] ;
    if isLoggedIn(0,ctemp) then
      begin
        { Show Stats Window }
        try
          application.createForm(TWinUserStats,winUserStats) ;
          winUserStats.netname.text := ctemp ;
          winUserStats.showModal ;
          { Send Line Message to Self ... because we can.}
          if ctemp = whoAmi(0) then
            begin
              if not sendLineMessage(0,ctemp,'Hey! Watch Where You''re Clicking That Mouse!') then
                alertBox('Have You Disabled Broadcasts?');
            end;
        finally
          winUserStats.free ;
        end;
        {get a list of current user's open files}
        tempList := getConnOpenFiles(0,getConnectID(0)) ; 
        ctemp := 'Network Files You Have Open:;;' ;
        if (tempList.count > 0) then
          begin
            for nloop := 0 to (tempList.count-1) do 
              ctemp := ctemp + tempList[nloop] + ';' ;
            okbox(ctemp) ;  
          end;
      end
    else
      begin
        username.caption := fullName(0,ctemp)  ;
        loggedin.caption := 'Is NOT Logged In!' ;
      end;
  end;

procedure TwinMain.groupsDblClick(Sender: TObject);
  begin
    username.caption := groups.items[groups.itemindex] ;
    loggedin.caption := GetObjID(0,groups.items[groups.itemindex],nw_group) ;
    { Get Members }
    header1.sections[0] := lowerCase(username.caption) ;
    everyone.clear ;
    everyone.items.addstrings(GetMemberList(getPrimaryServerID,username.caption,true)) ;
  end;

procedure TwinMain.bExitClick(Sender: TObject);
  begin
    close ;
  end;

procedure TwinMain.mapBtnClick(Sender: TObject);
  var
    chtemp : char ;
  begin
    chtemp := getNextNetDrive ;
    if yesNoBox('Mapping Drive ' + chtemp +  ': to;' +
                getServerName(getPrimaryServerID) + '/SYS:\;;' +
                'OK With You?') then
      begin
          {make the map call}
          if map(getNextNetDrive,
               getServerName(getPrimaryServerID) + '/sys:') then 
          {refresh the list}
          begin
            mapList.clear ;
            mapList.items.addStrings(mapShow) ;
            netdrive.caption := getFirstNetDrive + ':' +
                                '     Next Free: ' +
                                getNextNetDrive + ':' ;
            OKBox(chtemp + ';Drive Map Created Successfully!')
          end
        else
          alertBox('Error Mapping Drive ' + chtemp + ':') ;
      end;
  end;

procedure TwinMain.bEnableClick(Sender: TObject);
  begin
    if EnableLogins(GetPrimaryServerID) then
      begin
        bEnable.enabled := false ;
        bDisable.enabled := True ;
        canLogin.checked   := serverLoginOK(0) ;
      end
    else
      AlertBox('You Must Have Console Privileges to Enable Logins!') ;
  end;

procedure TwinMain.bDisableClick(Sender: TObject);
  begin
    if YesNoBox('Disabling Logins Can be Dangerous!;;Continue?') then
      begin
        if DisableLogins(GetPrimaryServerID) then 
          begin
            bEnable.enabled := True ;
            bDisable.enabled := False ;
            canLogin.checked   := serverLoginOK(0) ;
          end
        else
          AlertBox('Could Not Disable Logins;;Maybe They''re Already Disabled?') ;
      end;
  end;

procedure TwinMain.serverlistDblClick(Sender: TObject);
  var
    cserver : string ;
    nServer : TNWConnHandle ;
  begin
    if (serverList.items.count < 1) then
      exit ;
    cserver := serverlist.items[serverlist.itemindex] ;
    nServer := getServerHandle(cserver) ;
    servertext.text := 'sn: ' + intToHex(getServerSerial(cserver),8) + '/' +
                       'conID: ' + intToStr(getConnectID(nserver)) ;
    { show server's volumes/set preferred server ID }
    volumes.items.clear ;
    volumes.items.addStrings(getVolumes(getServerHandle(cServer))) ;
    if yesNoBox('Make ' + cserver + ' Your Preferred Server?') then
      if setPreferredServer(cserver,nServer) then
        okbox(cServer + ';Is Now Your Primary Server Connection') 
      else
        alertBox(cserver + ';Error Setting Preferred Server') ;
  end;

procedure TwinMain.bLogoutClick(Sender: TObject);
  var 
    ltemp : boolean ;
  begin
    if yesNoBox('Logoff Server ' + getServerName(0) + '?') then
      begin
        if nwBase1.ndsAvailable then
          ltemp := NDSLogout 
        else
          ltemp := NWLogout(0) ;
        if ltemp then
          OKBox('You Asked For It!') 
        else
          alertBox('Big Problem!;;Could Not Logout!?') ;
      end;
  end;

procedure TwinMain.captureBtnClick(Sender: TObject);
  begin
    try
      application.createForm(TWinCapture,winCapture) ;
      winCapture.showModal ;
    finally
      winCapture.Free ;
    end;
  end;

procedure TwinMain.mapListDblClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    ctemp := maplist.items[maplist.itemindex] ;
    username.caption := Copy(ctemp,1,2) ;
    loggedin.caption := Copy(ctemp,3,length(ctemp)-2) ;
  end;

procedure TwinMain.statsBtnClick(Sender: TObject);
  begin
    try
      application.createform(TwinStats,winStats) ;
      winStats.showModal ;
    finally
      winstats.free ;
    end;
  end;

procedure TwinMain.filesBtnClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    try
      ctemp := filesBtn.caption ;
      filesBtn.caption := 'Wait...' ;
      application.createForm(TWinFile,winFile) ;
      winFile.showmodal ;
    finally
      winFile.free ;
      filesBtn.caption := ctemp ;
    end;
  end;

procedure TwinMain.rightsBtnClick(Sender: TObject);
  var
    nwRights : TNWRights ;
  begin
    { Effective Rights Test }
    if getEffectiveRights(0,'sys:public',nwRights) then
      begin
        okbox('Your Effective Rights in SYS:PUBLIC:;;' +
            iif(nwRights.supervisor   ,'Supervisor;','') +
            iif(nwRights.read         ,'Read;','') +
            iif(nwRights.write        ,'Write;','') +
            iif(nwRights.create       ,'Create;','') +
            iif(nwRights.accessControl,'AccessControl;','') +
            iif(nwRights.fileScan     ,'FileScan;','') +
            iif(nwRights.modify       ,'Modify','') ) ;
        if noYesBox('Update Server ' + getServerName(0) + '''s Date/Time to ' +
                formDate(date) + '? ') then
          setServerDateTime(0,date) ;
      end
    else
      alertBox('Error Retrieving Rights;;Probably an Invalid Path Specification') ;
  end;

procedure TwinMain.ChangePassword1Click(Sender: TObject);
  var
    newPass : string ;
  begin
    newpass := space(20) ;
    if inputQuery('Change User Password','Type New Password',newPass) then
       begin
         if changeNWPassword(getPrimaryServerID,
                             everyone.items[everyone.itemIndex],
                             newPass,
                             '') then {must provide old password if not a supervisor!}
           okBox('Password Changed Successfully')
         else
           alertBox('Password Not Changed!;;Change This Code to Allow Non-Supervisor Changes') ;
       end
  end;

procedure TwinMain.SendLineMessage1Click(Sender: TObject);
  var
    messageText : string ;
  begin
    messageText := space(20) ;
    if inputQuery('Send Line Message','Type Message',messageText) then
       begin
         if sendLineMessage(0,everyone.items[everyone.itemIndex],
                            messageText)then
           okBox('Line Message Sent to ' + everyone.items[everyone.itemIndex]) 
         else
           alertBox('Line Message Not Sent!') ;
       end
  end;

procedure TwinMain.ndsBtnClick(Sender: TObject);
  begin
    application.createForm(TWinNDS,winNDS) ;
    try
      winNDS.showModal ;
    finally
      winNDS.free ;
    end;
  end;

procedure TwinMain.binderyBtnClick(Sender: TObject);
  var
    ncursor : TCursor ;
  begin
    ncursor       := screen.cursor ;
    screen.cursor := crHourglass ;
    try
      application.createForm(TWinProp,winProp) ;
      screen.cursor := ncursor ;
      winProp.showModal;
    finally
      winProp.free ;
      screen.cursor := ncursor ;
    end;
  end;

procedure TwinMain.semaphoreBtnClick(Sender: TObject);
  begin
    try
      application.createForm(TwinSemaphore,winSemaphore) ;
      winSemaphore.showModal ;
    finally
      winSemaphore.free ;
    end;
  end;

procedure TwinMain.mapInfoMenuClick(Sender: TObject);
  var
    ctemp : string ;
    mapInfo : TNWMapInfo ;
  begin
    if (mapList.items.count < 1) then
      exit ;
    if (mapList.itemIndex < 0) then
      mapList.itemIndex := 0 ;
    ctemp := mapList.items[mapList.itemIndex] ;
    if getMapInfo(ctemp[1],mapInfo) then
      okbox('Drive ' + ctemp[1] + ' Map Information;;' +
            'Server: ' + mapInfo.serverName + ';' + 
            'Path: ' + mapInfo.fullPath)
    else
      alertBox('Error Getting Map Info for Drive ' + ctemp[1]) ; 
  end;

procedure TwinMain.mapDelMenuClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    if (mapList.items.count < 1) then
      exit ;
    if (mapList.itemIndex < 0) then
      mapList.itemIndex := 0 ;
    ctemp := mapList.items[mapList.itemIndex] ;
    if noYesBox('Delete Mapping for Drive ' + ctemp[1] + ';Are You Sure') then
      begin
        if mapDelete(ctemp[1]) then
          begin
            mapList.clear ;
            mapList.items.addStrings(mapShow) ;
            okBox('Drive ' + ctemp[1] + ' Deleted Successfully')
          end
        else
          alertBox('Error Deleting Mapping for Drive ' + ctemp[1]) ;
      end;
  end;

procedure TwinMain.userListBtnClick(Sender: TObject);
  var
    newContext : TNWDSContextHandle ;
    tempContext : string ;
  begin
    try
      application.createForm(TWinUserList,winUserList) ;
      with winUserList do begin
        userListBox.items.addStrings(getUserList(0,false)) ;
        with serverCombo do begin
          items.clear ;
          items.addStrings(getConnectedServerList) ;
          itemIndex := items.indexOf(getServerName(getPrimaryServerID)) ;
          if (items.count < 2) then
            style := csSimple ;
        end;
        showModal ;
      end;
      ndsSetContextName(newContext,tempContext) ;
    finally
      winUserList.free ;
    end;
  end;


procedure TwinMain.serverListPopupStatsClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    ctemp := '[' + whoAmI(0) + '] ' ;
    if inputQuery('Send Console Message','Type Text:',ctemp) then
      begin
        if broadcastToConsole(0,ctemp) then
          okBox('Message Sent to Server Console!') 
        else 
          alertBox('Error Sending Broadcast to Console!') ;
      end;
  end;

procedure TwinMain.volumesDblClick(Sender: TObject);
  var
    volStats : VOL_STATS ;
  begin
    with volumes do
      if volInfo(0,items[itemIndex],volStats) then
        with volStats do 
          okBox(items[itemIndex] + ' Statistics:;;' + 
            'Volume Number: '+ lTrim(format('%7.0n',[volumeNumber * 1.0])) + ';' + 
            'Total Blocks: ' + lTrim(format('%7.0n',[totalBlocks * 1.0])) + ';' + 
            'Sectors Per Block: ' + lTrim(format('%7.0n',[sectorsPerBlock * 1.0])) + ';' + 
            'Available Blocks: ' + lTrim(format('%7.0n',[availableBlocks * 1.0])) + ';' + 
            'Total Directory Blocks: ' + lTrim(format('%7.0n',[totalDirectorySlots * 1.0])) + ';' +
            'Available Directory Blocks: ' + lTrim(format('%7.0n',[availableDirectorySlots * 1.0])) + ';' +
            'Removeable Drive: ' + iif(isRemovable=1,'Yes','No') ) ; 
  end;

end.
 